#ifndef __CFileManager__
#define __CFileManager__

#include "../Basics/CSystemString.hpp"
#include "CFileInformation.hpp"
#include "../Collections/CollectionTypedef.h"

//	===========================================================================

using Exponent::Basics::CSystemString;
using Exponent::Host::CFileInformation;
using Exponent::Collections::TCountedPointerArray;
using Exponent::Collections::TStringCountedPointerArray;

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CFileManager CFileManager.hpp
		 * @brief Manages folders and files
		 *
		 * @date 24/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.0.1 Added in place GetFileInDirectory function
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CFileManager.hpp,v 1.7 2007/02/08 21:06:44 paul Exp $
		 */
		class CFileManager
		{
		public:

//	===========================================================================

			/**
			 * Does a file exist
			 * @param filename Name of the fle to look for
			 * @retval bool True if file exists in location, false otherwise
			 */
			static bool doesFileExist(const CSystemString &filename);

			/**
			 * File is in the directory
			 * @param filename Name of the file to check for
			 * @param path The folder you want to look inside
			 * @retval bool True if file exists in location, false otherwise
			 */
			static bool fileExistsInDirectory(const CSystemString &filename, const CSystemString &path);

			/**
			 * Is the path to a folder
			 * @param path The path to check
			 * @retval bool True if path is to a folder, false otherwise
			 */
			static bool isFolderPath(const CSystemString &path);

			/**
			 * Get all the files in a directory (path should end with *.*, fills string array with filenames)
			 * @param path The path to get files for
			 * @param array On return is filled with strings of the filenames
			 */
			static void getFilesInDirectory(const CSystemString &path, TStringCountedPointerArray *array);

			/**
			 * Get all of the files in a directory (path ends with *.* and returns an array of CFileInformation)
			 * @param array The array to fill with CFileInformation
			 * @param path The path to scan
			 */
			static void getFilesInDirectory(TCountedPointerArray<CFileInformation> &array, const CSystemString &path);

			/**
			 * Get the number of files in the directory (path should end with *.*)
			 * @param path The path to scan
			 * @retval long The number of files in the directory
			 */
			static long getNumberOfFilesInDirectory(const CSystemString &path);

			/**
			 * Get the current directory (On mac returns the current working directory
			 * @param string On return is filled with the cwd
			 * @param addTrailingSlashes If true appends system seperator to end of string
			 */
			static void getApplicationDirectory(CSystemString &string, bool addTrailingSlashes = false);

			/**
			 * Create a folder
			 * @param string Path to create folder at
			 * @retval bool True if created properly, false otherwise
			 */
			static bool createNewFolder(const CSystemString &string);

			/**
			 * Sort a contents list in to alphabetical order (with folder first)
			 * @param array The array of CFileInformation to sort
			 */
			static void sortDirectoryContents(TCountedPointerArray<CFileInformation> &array);

		};
	}
}
#endif	// End of CFileManager.hpp